<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class JsmLogCreate extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if (!Schema::hasTable('jsm_log')) {
			Schema::create('jsm_log', function (Blueprint $table) {
				$table->bigIncrements('id')->unsigned();
				$table->string('nome_azione')->nullable();
				$table->string('tipo_azione')->nullable();
				$table->string('url', 2048)->nullable();
				$table->integer('utente')->unsigned()->nullable();
				$table->string('ip')->nullable();
				$table->longText('info', 65535)->nullable();
				$table->tinyInteger('inviare')->default(0);
				$table->longText('old_data', 65535)->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('jsm_log');
    }
}
