<?php

namespace App;

use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];
	
	
	public function isAdmin(){
		return ($this->tipo == 1);
	}

	
	/**
	 * salva la data/ora e l'ip da cui si sta collegando l'utente
	 * 
	 * @param type $request
	 */
	public function log_access($request){
		$this->last_access = date("Y-m-d H:i:s");
		$this->ip = $request->ip();
		
		$this->save();
	}
	
	
	/**
	 * 
	 * @return \App\Models\Utenti
	 */
	public function utente_obj(){
		
		try{
			$utente_obj = Models\Utenti::find($this->getKey());
		} catch (\Exception $ex) {
			$utente_obj = new Models\Utenti();
		}
		
		return $utente_obj;
	}
}
