<?php

namespace JSM\Base\Classes;

class ElencoTraduzioni {

    protected $arr_traduzioni = [];
    protected $current_lang = null;
    protected $nome_colonna;
    protected $fixed_lang;

    public function __construct($fixed_lang = null)
    {
        $this->fixed_lang = $fixed_lang;
        $this->init($fixed_lang);
    }


    public function init($fixed_lang = null){

        if(config("par.MULTILINGUA", false) && !app()->runningInConsole()){

            $lingua_sito = $fixed_lang ?? \Session::get("lingua_sito", config("par.DEFAULT_USER_LANGUAGE", "ITA")); //recuperiamo la lingua con cui l'utente desidera vedere il sito
            $lingua_sito = strtoupper($lingua_sito);

            $lingua_default = strtoupper(config("par.DEFAULT_SITE_LANGUAGE")); //questa e' la lingua con cui sono stati scritti tutti i messaggi nel sito
            
            $colonna_default = "valore_".strtolower($lingua_default); //e questa e' la rispettiva colonna sul DB

            //se la lingua in cui siamo e' la stessa usata in precedenza, non facciamo nulla, tanto abbiamo gia' tutto
            if($lingua_sito === $this->current_lang){
                return;
            }

            $this->current_lang = $lingua_sito;

            $nome_colonna = "valore_ita";

            switch($lingua_sito){
                case "ITA":
                    $nome_colonna = "valore_ita";
                    break;
                case "ENG":
                    $nome_colonna = "valore_eng";
                    break;
                case "SPA":
                case "ESP":
                    $nome_colonna = config("jsm_multilingua.spagnolo_legacy", true) ? "valore_spa" : "valore_esp";
                    break;
                case "PRT":
                    $nome_colonna = "valore_prt";
                    break;
                default:
                
                    //andiamo a cercare in modo automatico la lingua sulla base del suffisso, altrimenti ricadiamo sull'italiano
                    $elenco_colonne = array_filter(\Schema::getColumnListing(config("jsm_tables_names.traduzioni_name", "traduzioni")), function($el){
                        return strpos($el, "valore_") === 0;
                    });

                    $lingua_ipotetica = "valore_".strtolower($lingua_sito);
                    $nome_colonna = in_array($lingua_ipotetica, $elenco_colonne, true) ? $lingua_ipotetica : "valore_ita";
                
                    break;
            }

            $this->nome_colonna = $nome_colonna;
            $this->arr_traduzioni = \jsmTraduzioni::pluck($nome_colonna, $colonna_default)->toArray();
        }
    }

    /**
     * ritorna un array con l'elenco delle traduzioni nella lingua impostata nel sito
     *
     * @return array
     */
    public function toArray(): array{
        $this->init($this->fixed_lang);
        return $this->arr_traduzioni;
    }

    /**
     * ritorna il valore della traduzione per il testo ricevuto nella lingua corrente del sito
     *
     * @param string $valore_default
     * @return \stdClass|null
     */
    public function get_traduzione($valore_default){
        
        $val = $this->toArray()[$valore_default] ?? null;

        if(in_array($valore_default, array_keys($this->toArray()), true)){
            $out = new \stdClass();
            $out->{$this->nome_colonna} = $val;
            $out->value = $val;
        }else{
            $out = $val;
        }

        return $out;
    }

    /**
     * permette di aggiungere un valore "live" in modo da non inserirlo piu' volte su DB se la stessa stringa viene stampata piu' volte nella stessa pagina
     *
     * @param string $testo
     * @return void
     */
    public function add_runtime_value($testo){
        $this->arr_traduzioni[$testo] = $testo;
    }
}