<?php
use Illuminate\Support\Str;
class jsmBuilder  extends  \Illuminate\Database\Eloquent\Builder
{
    /**
     * Invocazione inline dell'applica_permessi. il modello è dedotto dalla query
     *
     * @param Users $user_obj
     * @return $this
     */
    public function applicaPermessi($user_obj = null,$forceConstraints = false)
    {
        $builder = $this;

        $callback = function() use ($builder,$user_obj){
            $nome_classe = get_class($builder->model);
            $nome_classe::applica_permessi($builder,$user_obj);
            return $builder;
        };

        if($forceConstraints){
            return jsmRelation::withConstraints($callback);
        }else{
            return $callback();
        }
    }

    /**
     * Invocazione inline dell'applica_permessi. il modello è dedotto dalla query
     *
     * @param String $metodo_filtro nome del metodo statico da invocare
     * @param array $opzioni_filtro Array dei parametri da passare al filtro
     * @return $this
     */
    public function jsmFilter($metodo_filtro, $opzioni_filtro = array())
    {
        $nome_classe = get_class($this->model);
        if(method_exists($nome_classe, $metodo_filtro)){
            $reference = $this;
            call_user_func_array($nome_classe."::".$metodo_filtro, array_merge([&$reference],$opzioni_filtro));
		}
        return $this;
    }

    public function optionSelect($etichetta, $valore,$allow_empty = true)
    {
        $etichettaIsMethod = Str::endsWith($etichetta,"()");
        if($etichettaIsMethod){
            $etichetta = substr($etichetta,0,strlen($etichetta)-2);
        }
        $valoreIsMethod = Str::endsWith($valore,"()");
        if($valoreIsMethod){
            $valore = substr($valore,0,strlen($valore)-2);
        }
        $out = $this->applicaPermessi()->get()->reduce(function($carry,$el) use ($etichetta,$valore,$valoreIsMethod,$etichettaIsMethod){
            $carry[$valoreIsMethod?$el->{$valore}():$el->$valore] = $etichettaIsMethod?$el->{$etichetta}():$el->$etichetta;
            return $carry;
        },[]);

        return $allow_empty ? ([""=>"--"]+$out):$out;
    }
}