<?php

//namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Log;

/**
 * Class JsmLog
 */
class jsmLog extends Model
{
    protected $table = 'jsm_log';
	
	public function __construct(array $attributes = array()){
		parent::__construct($attributes);
		
		$this->table = config("jsm_tables_names.jsm_log_name", "jsm_log");
	}

    public $timestamps = true;

    protected $fillable = [
        'nome_azione',
        'tipo_azione',
        'url',
        'utente',
        'ip',
        'info',
        'inviare',
        'old_data'
    ];

    protected $guarded = [];

	/*
	 * Per queste classi non vengono effettuati i log (altrimenti andiamo in loop)
	 */
	public static $excluded_class = ["LogJsm", "jsmLog"];

	
	/**
	 * Se i log sono abilitati, salva un record nel DB, eventualmente salvando anche i dati precedenti alla modifica
	 * 
	 * @param string $nome_azione
	 * @param string $tipo_azione
	 * @param null|array|string $info NULL | array | string informazioni aggiuntive
	 * @param Model $current_obj NULL | oggetto corrente
	 * @param mixed $manual_old_data
	 * @return void
	 * @throws \Exception
	 */
	public static function log_event($nome_azione, $tipo_azione, $info=null, $current_obj=null, $manual_old_data=null){
		
		if(config("jsm_log.log_enabled", false) === false){
			return;
		}
		
		$old_data = null;
		
		if(config("jsm_log.log_save_old_data", false) === true){
			
			if($manual_old_data !== null){
				
				if(is_string($manual_old_data)){
					$old_data = $manual_old_data;
				}else{
					try{
						$old_data = json_encode($manual_old_data);
					} catch (\Exception $ex) {
						Log::error("Errore encoding old_data: ".$ex->getMessage(), context_error_details(false));
	
						if(config('app.debug')){
							throw $ex;
						}
					}
				}

				
			}elseif(is_object($current_obj)){
			
				try{

					$old_data = [];
					$new_data = $current_obj->getDirty();
					unset($new_data["updated_at"]); //questa info ce l'abbiamo nel valore updated_at del record

					if(!$current_obj->wasRecentlyCreated){
						foreach($current_obj->getDirty() as $key => $val){
							// if($key == "updated_at"){
							// 	continue;
							// }
							$old_data[$key] = $current_obj->getOriginal()[$key] ?? null;
						}
					}

					$old_data = json_encode([
						"old_data" => $old_data,
						"new_data" => $new_data,
					]);

				} catch (\Exception $ex) {
					Log::error("Errore estrazione old_data: ".$ex->getMessage(), context_error_details(false));

					if(config('app.debug')){
						throw $ex;
					}
				}
			}
		}
		
		try{
			$url = \Request::fullUrl();
			$ip = \Request::ip();

			$id_utente = \Auth::user() !== null ? \Auth::user()->getKey() : null;

			if(is_array($info)){
				$info = json_encode($info);
			}

			self::create([
				'nome_azione' => $nome_azione,
				'tipo_azione' => $tipo_azione,
				'url' => $url,
				'utente' => $id_utente,
				'ip' => $ip,
				'info' => $info,
				'old_data' => $old_data,
			]);
			
		} catch (\Exception $ex) {
			Log::error("Errore salvataggio log: ".$ex->getMessage(), context_error_details(false));
			
			if(config('app.debug')){
				throw $ex;
			}
		}
	}
	
}