<?php
namespace JSM\Base\Models;

use jsmModel;
use Txd\txdFields;

class Generic extends jsmModel
{
    use \Txd\Traits\txdModel;
    public function init_db_fields() {
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

        if(is_null($this->db_fields)){
            
            $db_fields = new txdFields($this);
     
            $db_fields->build();
        }
    }

    public function __construct(array $attributes = array()){

        /** 
         * se l'attributo e' settato prima di invocare il modello, carica automaticamente db_fields, 
         * cosi' da generare i fillable anche nei firstOrNew e simili
         * 
         */
        if(self::$AUTO_LOAD_DB_FIELDS){
            $this->init_db_fields();
        }

        parent::__construct($attributes);

        //andiamo ad impostare nel modello le regole a partire dai vincoli del DB (lunghezza e tipo)
        if(isset($this->db_rules) && is_array($this->db_rules)){

            // supporto legacy per le rules eventualmente definite nell'array della classe estesa
            $rules_modello_esteso = is_array($this->rules) ? $this->rules : [];

            foreach($rules_modello_esteso as $key => $value){
                if(isset($this->db_rules[$key])){
                    if(!is_array($rules_modello_esteso[$key])){
                        $rules_modello_esteso[$key] = explode("|",$rules_modello_esteso[$key]);
                    }
                    $db_rules_for_current_key = $this->db_rules[$key];
                    if(!is_array($db_rules_for_current_key)){
                        $db_rules_for_current_key = explode("|",$db_rules_for_current_key);
                    }
                    $rules_modello_esteso[$key] = array_merge($rules_modello_esteso[$key],$db_rules_for_current_key);
                }
            }

            $this->rules = array_merge($this->db_rules, $rules_modello_esteso);
        }
    }

	
	protected $table = 'no_table';

	//array con i tipi per la conversione dei dati
	protected $types = [
		
	];

	//Contiene le regole di validazione dei campi legate al DB (eg. numeric|max, etc...)
	//l'elenco completo dei controlli aggiunti da noi e' nel jsmServiceProvider
	protected $db_rules = [
	];

}
