<?php

namespace JSM\Base;
use Swift_Mailer;

class PostmanSwiftMailer extends Swift_Mailer{

	public function send(\Swift_Mime_SimpleMessage $message, &$failedRecipients = null){
		
//		dd($message);
		
		//andiamo a vedere se per questa mail e' stato definito di salvare il Raw su disco
		$message_custom_attributes = (property_exists($message, "custom_attributes") && is_array($message->custom_attributes) ? $message->custom_attributes : []);

		if(isset($message_custom_attributes["save_source_on_disk"]) && $message_custom_attributes["save_source_on_disk"] === true){
			$disk_name = isset($message_custom_attributes["disk_name"]) ? $message_custom_attributes["disk_name"] : "";
			$path_prefix = isset($message_custom_attributes["path_prefix"]) ? $message_custom_attributes["path_prefix"] : "";
			$override_message_with_path = isset($message_custom_attributes["override_message_with_path"]) ? $message_custom_attributes["override_message_with_path"] : "";
			
			$file_name = date("Y-m-d_His")."_".str_slug($message->getSubject()).".eml";
			
			if(strlen($disk_name) > 0 && config("filesystems.disks.".$disk_name) !== null){
				
				\Storage::Disk($disk_name)->put($path_prefix.$file_name, $message->toString());
				
				//se questo parametro e' impostato a TRUE, andiamo a sovrascrivere l'attributo "override_message" eventualmente impostato nel metodo sendAsRaw() con il nome del file salvato
				if($override_message_with_path){
					$message->custom_attributes["override_message"] = $path_prefix.$file_name;
				}
				
			}
		}
		
		return parent::send($message, $failedRecipients);
	}
}