<?php

namespace JSM\Base\Middleware;

use Closure;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Foundation\Http\Exceptions\MaintenanceModeException;


class CheckForMaintenanceMode{

	protected $app;

	public function __construct(Application $app){
		$this->app = $app;
	}

	/**
	 * 
	 * @param type $request
	 * @param Closure $next
	 * @return type
	 * @throws MaintenanceModeException
	 */
	public function handle($request, Closure $next){
		
		if ($this->app->isDownForMaintenance() && !$this->isIpWhiteListed()) {
            $data = json_decode(file_get_contents($this->app->storagePath().'/framework/down'), true);

            throw new MaintenanceModeException($data['time'], $data['retry'], $data['message']);
        }

        return $next($request);
	}
	
	
	/**
	 * 
	 * @return type
	 */
	private function isIpWhiteListed(){
		
		$ip = \Request::getClientIp();
		$allowed = config("jsm_maintenance.whitelisted_ip");

		return in_array($ip, $allowed);
	}

}
