<?php

//namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Log;

/**
 * Class jsmDoc
 */
class jsmDoc extends Model
{
    protected $table = 'log_invocazione_metodi';
	protected $connection = 'jsm_doc_DB';

    public $timestamps = true;

    protected $fillable = [
        'applicativo',
        'nome_metodo',
        'nome_classe',
        'nome_file',
        'route_uri',
        'last_full_url',
        'ip',
        'info',
        'parametri_querystring',
        'timezone',
    ];

    protected $guarded = [];

	
	/**
	 * 
	 * @param type $nome_metodo
	 * @param type $info
	 * @return type
	 * @throws \Exception
	 */
	public static function log_method($nome_metodo, $nome_classe = null, $nome_file = null, $info=null, $last_called_file = null){
		
		//se i log sono disabilitati o se l'app non sta girando in locale, usciamo
		if(config("jsm_doc.doc_enabled", false) === false || env("APP_ENV") !== "local"){
			return;
		}
		
		if(!is_string($last_called_file)){
			$last_called_file = "";
		}
		
		if(config("jsm_doc.doc_verbosity", 1) < 2 && basename($last_called_file) === "jsmModel.php"){
//			die("skipped 2");
			return;
		}elseif(config("jsm_doc.doc_verbosity", 1) < 1 && basename($last_called_file) == "jsmController.php"){
//			die("skipped 1");
			return;
		}
		

		$arr_info = array();
		
		if($info !== null){
			$arr_info["info"] = $info;
		}
		
		try{
			
//			$url = \Request::url();
			$url = \Request::fullUrl();
			$ip = \Request::ip();
			
//			echo "<p>".app_path();
//			echo "<p>".base_path();
			
//			$contents = File::get(base_path()."/.git/config");
			
			
			/*
			 * recuperiamo il nome del progetto dal remote di git
			 */
			try{
				$contents = parse_ini_file(base_path()."/.git/config", true);
				
				$url_repository = isset($contents["remote origin"]["url"]) ? $contents["remote origin"]["url"] : "";
				$info_repo = explode("/r/", $url_repository);

				if(count($info_repo) > 1){
					array_shift($info_repo);
				}

				$applicativo = join("", $info_repo);
				
			} catch (\Exception $ex) {
				$applicativo = base_path();
				$arr_info["eccezione_applicativo"] = $ex->getMessage();
			}
			
			if(strlen($applicativo) == 0){
				$applicativo = base_path();
				$arr_info["eccezione_applicativo"] = "origin mancante";
			}
			
			
			/*
			 * andiamo a vedere se include le librerie base e la versione
			 */
			
			$arr_pacchetti = array();
			$arr_pacchetti[] = $jsm_base_version = null;
			$arr_pacchetti[] = $jsm_doc_version = null;
			$arr_pacchetti[] = $models_generator_version = null;
			
			$pack_found = 0;
			
			//mettiamo in sessione anche la versione dei pacchetti, cosi' da non dover rileggere il file tutte le volte
			$session_package = \Session::get("jsm_session_package", array());

			if(count($session_package) > 0){
				if(isset($session_package["jsm/base"])){$arr_info["jsm/base"] = $session_package["jsm/base"];}
				if(isset($session_package["jsm/doc"])){$arr_info["jsm/doc"] = $session_package["jsm/doc"];}
				if(isset($session_package["reliese/laravel"])){$arr_info["reliese/laravel"] = $session_package["reliese/laravel"];}
			}else{
				try{
					$composer_lock = json_decode(file_get_contents(base_path()."/composer.lock"), true);
					
					if(isset($composer_lock["packages"]) && is_array($composer_lock["packages"])){
						
						foreach($composer_lock["packages"] as $package){
							
							if(isset($package["name"]) && $package["name"] == "jsm/base"){
								$jsm_base_version = isset($package["version"]) ? trim($package["version"]) : null;
								$session_package["jsm/base"] = $arr_info["jsm/base"] = $jsm_base_version;
								$pack_found++;
							}
							
							if(isset($package["name"]) && $package["name"] == "jsm/doc"){
								$jsm_doc_version = isset($package["version"]) ? trim($package["version"]) : null;
								$session_package["jsm/doc"] = $arr_info["jsm/doc"] = $jsm_doc_version;
								$pack_found++;
							}
							
							if(isset($package["name"]) && $package["name"] == "reliese/laravel"){
								$models_generator_version = isset($package["version"]) ? trim($package["version"]) : null;
								$session_package["reliese/laravel"] = $arr_info["reliese/laravel"] = $models_generator_version;
								$pack_found++;
							}
							
							if($pack_found >= count($arr_pacchetti)){
								break;
							}
						}

						\Session::put("jsm_session_package", $session_package);
						try{
							\Session::save();
						} catch (\Exception $ex) {
							\Log::error(__FILE__." | ".__FUNCTION__." | ".$ex->getMessage());
						}
					}
					
				} catch (\Exception $ex) {
					$arr_info["eccezione_composer"] = $ex->getMessage();
				}
			}
			
			$route_uri =  \Route::getCurrentRoute()->uri();
			
			$nome_file = str_replace(base_path(), "", $nome_file);

			if(is_array($info)){
				$info = json_encode($info);
			}
			
			//prima di eseguire la connessione, controlliamo se e' gia' presente in sessione
			$session_doc = \Session::get("called_jsm_doc", array());
			
//			\Session::forget("called_jsm_doc");
//			\Session::save();
//			die("cleaned");
			
			if(isset($session_doc[$applicativo][$nome_classe][$nome_metodo][$route_uri])){
//				echo "<p>presente";
				return;
				
			}else{
//				echo "<p>assente";
//				\logger("invocazione metodo log");

				$session_doc[$applicativo][$nome_classe][$nome_metodo][$route_uri] = "gia documentato";
				\Session::put("called_jsm_doc", $session_doc);
				try{
					\Session::save();
				} catch (\Exception $ex) {
					\Log::error(__FILE__." | ".__FUNCTION__." | ".$ex->getMessage());
				}
			}
			
			
			$db_connection = false;
			try{
				\DB::connection("jsm_doc_DB")->getPdo();

				if(\DB::connection("jsm_doc_DB")->getDatabaseName() && Schema::connection("jsm_doc_DB")->hasTable("log_invocazione_metodi")){
					$db_connection = true;
				}else{
					$db_connection = false;
				}
			}catch(\Exception $e){
				$db_connection = false;
//				echo "<p>".$e->getMessage();
			}
			
			if($db_connection){
				$obj = self::firstOrNew([
					'applicativo' => $applicativo,
					'nome_classe' => $nome_classe,
					'nome_metodo' => $nome_metodo,
	//				'nome_file' => $nome_file,
					'route_uri' => $route_uri,
				]);

	//			$parametri_querystring = $obj->parametri_querystring;
	//			if(!is_array($parametri_querystring)){$parametri_querystring = array();}
	//			
	//			try{
	//				foreach(\Request::input() as $key => $value){
	//					$parametri_querystring[$key] = $value;
	//				}
	//			} catch (\Exception $ex) {
	//
	//			}


				$obj->nome_file = $nome_file;
				$obj->last_full_url = $url;
				$obj->ip = $ip;
				$obj->info = json_encode($arr_info);
				$obj->timezone = config("app.timezone");
	//			$obj->parametri_querystring = json_encode($parametri_querystring);

				$obj->save();
			}
			
		} catch (\Exception $ex) {
			Log::error("Errore salvataggio log: ".$ex->getMessage());
			
			if(config('app.debug')){
				throw $ex;
			}
		}
	}
	
}