<?php

namespace JSM\ExecutionTimeMeasure\Exception;

use JSM\ExecutionTimeMeasure\ETMClient;

/**
 * Configuration Exception Class
 */
class ConfigurationException extends \Exception
{


    /**
     * ETMClient instance that threw the exception
     * @var ETMClient
     */
    protected $instance;


    /**
     * Create new instance
     * @param ETMClient $instance ETMClient instance that threw the exception
     * @param string $message Exception message
     */
    public function __construct($instance, $message)
    {
        $this->instance = $instance;
        parent::__construct($message);
    }

    /**
     * Get ETMClient instance that threw the exception
     * @return ETMClient ETMClient instance
     */
    public function getInstance()
    {
        return $this->instance;
    }
}
