<?php

namespace JSM\ExecutionTimeMeasure\Provider;

use Illuminate\Support\ServiceProvider;
use JSM\ExecutionTimeMeasure\ETMClient as ETMETMClient;

/**
 *  *
 * @author Fabio Spadea <fabio@techseed.it>
 */
class ExecutionTimeMeasureServiceProvider extends ServiceProvider
{

    /**
     * Boot the service provider.
     *
     * @return void
     */
    public function boot()
    {
        if (false !== strpos($this->app->version(), 'Lumen')) {
            $this->app->configure('jsm_execution_time_measure');
        } else {
            // Publish config files
            $this->publishes([
                __DIR__ . '/../../config/jsm_execution_time_measure.php' => config_path('jsm_execution_time_measure.php'),
            ], 'config');
        }

        $this->mergeConfigFrom(
			__DIR__.'/../../config/jsm_execution_time_measure.php', 'jsm_execution_time_measure'
		);

        app('router')->aliasMiddleware("execution_time_measure", \JSM\ExecutionTimeMeasure\Middleware\ExecutionTimeMeasureMiddleware::class);
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->registerETM();
    }

    /**
     * Register ETMETMClient
     *
     * @return void
     */
    protected function registerETM()
    {
        $this->app->singleton('jsm_execution_time_measure',
            function ($app) {
                // Set Default host and port
                $options = array();
                $config  = $app['config'];

                if (isset($config['jsm_execution_time_measure.host'])) {
                    $options['host'] = $config['jsm_execution_time_measure.host'];
                }

                if (isset($config['jsm_execution_time_measure.port'])) {
                    $options['port'] = $config['jsm_execution_time_measure.port'];
                }

                if (isset($config['jsm_execution_time_measure.timeout'])) {
                    $options['timeout'] = $config['jsm_execution_time_measure.timeout'];
                }

                if (isset($config['jsm_execution_time_measure.throwConnectionExceptions'])) {
                    $options['throwConnectionExceptions'] = (boolean) $config['jsm_execution_time_measure.throwConnectionExceptions'];
                }

                // Create
                $etm_ETMClient = new ETMETMClient();
                $etm_ETMClient->configure($options);
                return $etm_ETMClient;
            }
        );

        $this->app->bind('JSM\ExecutionTimeMeasure\ETMClient', function ($app) {
            return $app['jsm_execution_time_measure'];
        });
    }
}
