<?php

namespace JSM\ExecutionTimeMeasure\Middleware;

use Closure;

class ExecutionTimeMeasureMiddleware
{

    protected $metric_name;

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $className = str_replace('\\', '.', get_class($this));
        $this->metric_name = sprintf('%s.%s', $className, $request->route()->getName());
        \ExecutionTimeMeasure::startTiming($this->metric_name);
        \ExecutionTimeMeasure::middlewareFire();

        return $next($request);
    }

    public function terminate($request, $response){

        $className = str_replace('\\', '.', get_class($this));
        $this->metric_name = sprintf('%s.%s', $className, $request->route()->getName());
        
        \ExecutionTimeMeasure::endTiming($this->metric_name);
        \ExecutionTimeMeasure::send(config("jsm_execution_time_measure.log_to_file", false));

        // $endTime = microtime(true) - $this->start;
        // $dataToLog = 'Duration: ' . number_format($endTime - LARAVEL_START, 3) . "\n";$dataToLog .= 'IP Address: ' . $request->ip() . "\n";
    }
}