<?php

namespace JSM\jqueryGantt;


use Illuminate\Support\ServiceProvider;
class jqueryGanttServiceProvider extends ServiceProvider{
	
	/**
	 * Bootstrap the application services.
	 *
	 * @return void
	 */
	public function boot(){
		
		$viewPath = __DIR__.'/../resources/views';
        $this->loadViewsFrom($viewPath, 'jquerygantt');
        $this->publishes([
            $viewPath => base_path('resources/views/vendor/jquerygantt'),
        ], 'views');		
		
		$this->publishes([
			__DIR__ . '/../resources/assets' => public_path('vendor/jquerygantt'),
		], 'public');

		$this->publishes([
			__DIR__.'/config/jsm_jqueryGantt.php' => config_path('jsm_jqueryGantt.php'),
		], "config_jqueryGantt");

		$this->mergeConfigFrom(
			__DIR__.'/config/jsm_jqueryGantt.php', 'jsm_jqueryGantt'
		);

		$this->app->make('JSM\jqueryGantt\Controllers\jqueryGanttController');


		\Route::group([
			'middleware' => 'web',
				//'namespace' => $this->namespace,
				], function ($router){
			\Route::any('/jqueryGantt/{id}', @'\JSM\jqueryGantt\Controllers\jqueryGanttController@gantt_frame')->name("jquerygantt_frame");
			\Route::any('/jqueryGantt/{id}/save', @'\JSM\jqueryGantt\Controllers\jqueryGanttController@save')->name("jquerygantt_save");
			\Route::any('/jqueryGantt/{id}/load', @'\JSM\jqueryGantt\Controllers\jqueryGanttController@load')->name("jquerygantt_load");
		});


	}

	/**
	 * Register the application services.
	 *
	 * @return void
	 */
	public function register(){

	}
}
