<?php

namespace JSM\Postman;

use Illuminate\Mail\Transport\Transport;
use Illuminate\Support\Facades\Log;
use Swift_Mime_Message;

class PostmanTransport extends Transport{

	
	public function __construct(){
		
	}


	public function send(\Swift_Mime_Message $message, &$failedRecipients = null){
		
		if(count($message->getFrom()) > 0){
			$sender = $message->getFrom()[array_keys($message->getFrom())[0]]." <".array_keys($message->getFrom())[0].">";
		}else{
			$sender = "";
		}
		
		/*
		 * andiamo a recuperare la versione plain_text della mail, se presente
		 */
		$plain_text_message = "";
		
		try{
			foreach($message->getChildren() as $child){
				if($child->getContentType() === "text/plain"){
					$plain_text_message .= $child->getBody();
				}
			}
		} catch (\Exception $ex) {
			Log::error("Errore plain_text mail: ".$ex->getMessage());
			
			if(config('app.debug')){
				throw $ex;
			}
		}
		
		$esito = false;
		
		$dest_to = is_array($message->getTo()) ? $message->getTo() : array();
		$dest_cc = is_array($message->getCc()) ? $message->getCc() : array();
		$dest_bcc = is_array($message->getBcc()) ? $message->getBcc() : array();
		
		$formatted_to = [];
		$formatted_cc = [];
		$formatted_bcc = [];
		
		/*
		 * andiamo a comporre i destinatari della mail con anche il nome, correttamente codificato
		 */
		foreach($dest_to as $key => $value){
			$nome = $value;
			
			if(!mb_check_encoding($value, 'ASCII')){ //se il nome contiene dei caratteri non-ASCII, passiamolo codificato in base64, con le istruzioni opportune
				$nome = "=?utf-8?B?".base64_encode($value)."?=";
			}
			$formatted_to[] = $nome." <".$key.">";
		}
		
		foreach($dest_cc as $key => $value){
			$nome = $value;
			
			if(!mb_check_encoding($value, 'ASCII')){ //se il nome contiene dei caratteri non-ASCII, passiamolo codificato in base64, con le istruzioni opportune
				$nome = "=?utf-8?B?".base64_encode($value)."?=";
			}
			$formatted_cc[] = $nome." <".$key.">";
		}
		
		foreach($dest_bcc as $key => $value){
			$nome = $value;
			
			if(!mb_check_encoding($value, 'ASCII')){ //se il nome contiene dei caratteri non-ASCII, passiamolo codificato in base64, con le istruzioni opportune
				$nome = "=?utf-8?B?".base64_encode($value)."?=";
			}
			$formatted_bcc[] = $nome." <".$key.">";
		}
		
		$json_message = array(
			// Source is required
			'Source' => $sender,
			// Destination is required
			'Destination' => array(
				'ToAddresses' => $formatted_to,
				'CcAddresses' => $formatted_cc,
				'BccAddresses' => $formatted_bcc,
			),
			// Message is required
			'Message' => array(
				// Subject is required
				'Subject' => array(
					// Data is required
					'Data' => $message->getSubject(),
					'Charset' => 'UTF-8',
				),
				// Body is required
				'Body' => array(
					'Text' => array(
						// Data is required
						'Data' => $plain_text_message,
						'Charset' => 'UTF-8',
					),
					'Html' => array(
						// Data is required
						'Data' => $message->getBody(),
						'Charset' => 'UTF-8',
					),
				),
			)
		);
		

		//andiamo a vedere se per questa mail e' stato definito di inviarla come Raw
		$message_custom_attributes = (property_exists($message, "custom_attributes") && is_array($message->custom_attributes) ? $message->custom_attributes : []);

		if(isset($message_custom_attributes["send_as_raw"]) && $message_custom_attributes["send_as_raw"] === true){
			$json_message["Message"]["Raw"] = $message->toString();
			$json_message["Message"]["MessageLogOverride"] = (isset($message_custom_attributes["override_message"]) ? $message_custom_attributes["override_message"] : "false");
		}
		
		
		try{
			$cipher = new AESCipher(config("jsm_postman.postman_api_key"));
			$messaggio = $cipher->encrypt(json_encode($json_message));

			$url = config("mail.host", 'https://postman.sinergo.it/api/v3/postman');

			$eol = "\r\n";
			$data = '';
			$mime_boundary=md5(time());
			//
			$data .= '--' . $mime_boundary . $eol;
			$data .= 'Content-Disposition: form-data; name="id"' . $eol . $eol;
			$data .= config("jsm_postman.postman_id") . $eol;
			$data .= '--' . $mime_boundary . $eol;
			$data .= 'Content-Disposition: form-data; name="info"' . $eol . $eol;
			$data .= $messaggio . $eol;
			$data .= '--' . $mime_boundary . $eol;
			$data .= "--" . $mime_boundary . "--" . $eol . $eol;

			// use key 'http' even if you send the request to https://...
			$options = array(
				'http' => array(
					'header'  => "Content-type: multipart/form-data; boundary=" . $mime_boundary,
					'method'  => 'POST',
					'content' => $data
				)
			);

			$context  = stream_context_create($options);
			$result = file_get_contents($url, FILE_TEXT, $context);
			$result = json_decode($result, true);
		}catch(\Exception $e){
			$result = [
                "status" => "KO",
                "message" => $e->getMessage(),
            ];
        }
        

		if(!is_array($result)){
			$esito = false;
		}else{
			if(array_key_exists("status", $result)){
				if($result['status'] === "OK"){
					$esito = true;
				}
			}
		}
		
        if(!$esito){
            \Log::error(get_called_class()." | ".__FUNCTION__." | ".json_encode($result));

            if(config("app.debug")){
                throw new \JSM\Postman\Exceptions\PostmanException(json_encode($result));
            }
        }
		
		return $esito;
	}

}