<?php

namespace JSM\Postman\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class txdMail extends Mailable{

    use Queueable, SerializesModels;
    
    /**
     * questi servono nella classe estesa per poter assegnare i vari attributi
     */
    protected $body = "";
    protected $arr_allegati = [];

    public function body($html_text){
        $this->body = $html_text;
    }
    
    public function add_attachment($full_path){
        $this->arr_allegati[] = $full_path;
    }



    /**
     * da qui in poi iniziano attributi e metodi per gestire le funzionalita' aggiuntive
     */

	protected static $static_send_as_raw = false;
	protected static $static_override_message = false;
	
	protected static $save_source_on_disk = false;
	protected static $disk_name = "";
	protected static $path_prefix = "";
	protected static $override_message_with_path = false;


	/**
	 * imposta gli attributi in modo da inviare la mail a Postman come Raw, eventualmente andando a sovrascrivere il contenuto della mail in fase di log
	 * @param string $override_message [default "false"] se != "false" va a sovrascrivere il corpo del messaggio nei log
	 * @return $this
	 */
	public function sendAsRaw($override_message = false){
		self::$static_send_as_raw = true;
		self::$static_override_message = $override_message;
		
		return $this;
	}
	
	public function saveSourceOnDisk($disk_name, $path_prefix = "", $override_message_with_path = false){
		self::$save_source_on_disk = true;
		self::$disk_name = $disk_name;
		self::$path_prefix = $path_prefix;
		self::$override_message_with_path = $override_message_with_path;
		
		return $this;
	}

	
	/**
	 * funzione di callback chiamata su un messaggio Swift
	 * imposta alcuni parametri custom che ci serve salvare in fase di invio mail
	 * 
	 * @param type $swift_message
	 */
	public static function fill_custom_attributes($swift_message = null){
		
		if(is_object($swift_message)){
			$swift_message->custom_attributes["send_as_raw"] = self::$static_send_as_raw;
			$swift_message->custom_attributes["override_message"] = self::$static_override_message;
			
			$swift_message->custom_attributes["save_source_on_disk"] = self::$save_source_on_disk;
			$swift_message->custom_attributes["disk_name"] = self::$disk_name;
			$swift_message->custom_attributes["path_prefix"] = self::$path_prefix;
			$swift_message->custom_attributes["override_message_with_path"] = self::$override_message_with_path;
		}
	}

	
	/**
	 * 
	 * @param \Illuminate\Contracts\Mail\Mailer $mailer
	 */
	public function send(\Illuminate\Contracts\Mail\Mailer $mailer){
		
		$this->callbacks[] =  self::class."::fill_custom_attributes";
		
		parent::send($mailer);
	}
}