<?php

namespace JSM\Postman;

//use Illuminate\Support\ServiceProvider;
use Illuminate\Mail\MailServiceProvider;

class PostmanMailProvider extends MailServiceProvider{

	public function boot(){
		$this->mergeConfigFrom(
			__DIR__.'/config/jsm_postman.php', 'jsm_postman'
		);
	}

	
	function registerSwiftMailer(){
		
		if($this->app['config']['mail.driver'] == 'postman'){
			$this->registerPostmanSwiftMailer();
		}else{
            // parent::registerSwiftMailer();
            
            $this->registerSwiftTransport();

            // Once we have the transporter registered, we will register the actual Swift
            // mailer instance, passing in the transport instances, which allows us to
            // override this transporter instances during app start-up if necessary.
            $this->app->singleton('swift.mailer', function ($app) {
                return new PostmanSwiftMailer($app['swift.transport']->driver());
            });
		}
	}

	
	private function registerPostmanSwiftMailer(){
	
		/*
		 * versione funzionante con laravel < 5.4
		 */
//		$this->app['swift.mailer'] = $this->app->singleton(function ($app){
//			return new \Swift_Mailer(new PostmanTransport());
//		});
		
		/*
		 * versione adattata per laravel 5.5+
		 */
		$this->app->singleton('swift.mailer', function ($app) {
            return new PostmanSwiftMailer(new PostmanTransport());
        });
	}
}
