<?php

if(!function_exists("check_email")){

	/**
	 * verifica la validita' di un indirizzo mail usando il FILTER_VALIDATE_EMAIL se presente o un'espressione regolare in caso contrario
	 * 
	 * @param string $mail indirizzo da verificare
	 * @return boolean esito della verifica
	 */
	function check_email($mail){

		$esito = false;

		if(strlen($mail) == 0){
			return false;
		}

		if(find_filter("validate_email")){

			if(filter_var($mail, FILTER_VALIDATE_EMAIL) === false){
				$esito = false;
			}else{
				$esito = true;
			}
		}else{

			if(strlen($mail) > 5){
				$pattern = '/^(?!(?:(?:\\x22?\\x5C[\\x00-\\x7E]\\x22?)|(?:\\x22?[^\\x5C\\x22]\\x22?)){255,})(?!(?:(?:\\x22?\\x5C[\\x00-\\x7E]\\x22?)|(?:\\x22?[^\\x5C\\x22]\\x22?)){65,}@)(?:(?:[\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F-\\x39\\x3D\\x3F\\x5E-\\x7E]+)|(?:\\x22(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x21\\x23-\\x5B\\x5D-\\x7F]|(?:\\x5C[\\x00-\\x7F]))*\\x22))(?:\\.(?:(?:[\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F-\\x39\\x3D\\x3F\\x5E-\\x7E]+)|(?:\\x22(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x21\\x23-\\x5B\\x5D-\\x7F]|(?:\\x5C[\\x00-\\x7F]))*\\x22)))*@(?:(?:(?!.*[^.]{64,})(?:(?:(?:xn--)?[a-z0-9]+(?:-+[a-z0-9]+)*\\.){1,126}){1,}(?:(?:[a-z][a-z0-9]*)|(?:(?:xn--)[a-z0-9]+))(?:-+[a-z0-9]+)*)|(?:\\[(?:(?:IPv6:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){7})|(?:(?!(?:.*[a-f0-9][:\\]]){7,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?)))|(?:(?:IPv6:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){5}:)|(?:(?!(?:.*[a-f0-9]:){5,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3}:)?)))?(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))(?:\\.(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))){3}))\\]))$/iD';

				if(preg_match($pattern, $mail) === 1){
					$esito = true;
				}
			}
		}

		return $esito;
	}

}


if(!function_exists("find_filter")){

	/**
	 * verifica se e' presente il filtro passato come parametro
	 * 
	 * @param string $filtro nome filtro
	 * @return boolean esito
	 */
	function find_filter($filtro){

		$trovato = false;

		if(!function_exists("filter_list")){
			return false;
		}

		foreach(filter_list() as $value){
			if($value == $filtro){
				$trovato = true;
			}
		}

		return $trovato;
	}

}