<?php

namespace JSM\Postman;

//use Illuminate\Support\ServiceProvider;
use Illuminate\Mail\MailServiceProvider;

class PostmanMailServiceProvider extends MailServiceProvider{

	public function boot(){

		$this->publishes([
			__DIR__.'/views/mail' => base_path('resources/views/mail'),
		], "jsm_mail_views");

		$this->publishes([
			__DIR__.'/config/jsm_postman.php' => config_path('jsm_postman.php'),
		], "jsm_postman");


		$this->mergeConfigFrom(
			__DIR__.'/config/jsm_postman.php', 'jsm_postman'
		);
	}

	
	/**
     * Register the Illuminate mailer instance.
     *
     * @return void
     */
    protected function registerIlluminateMailer()
    {
        $this->app->singleton('mail.manager', function($app) {
            return new PostmanMailManager($app);
        });

        // Copied from Illuminate\Mail\MailServiceProvider
        $this->app->bind('mailer', function ($app) {
            return $app->make('mail.manager')->mailer();
        });
    }
}
