## Componente per inviare mail tramite Postman ##

_2021-09-14 | Versione aggiornata per supportare Laravel 7+, 8+_

Per installare il componente, come prima cosa aggiungere il repository al file *composer.json* del progetto

    ...
    "repositories": {
        ...
        "jsm-postman": {
            "type": "vcs",
            "url": "https://git.sinergo.it/gitblit/r/jsmLaravel/Postman.git"
        }
    },
    ...

quindi installare una versione >= 6.0

    composer require jsm/postman


Aggiungiamo il provider nella sezione *providers* di **config/app.php**

    ...
    \JSM\Postman\PostmanMailServiceProvider::class,
    ...

Pubblichiamo le views con le blade per le mail

    php artisan vendor:publish --tag=jsm_mail_views

ed eventualmente il file di configurazione

    php artisan vendor:publish --tag=jsm_postman

nel file **.env** vanno aggiunti i seguenti parametri configurati opportunamente

    ###
    # Sezione Email/SMS Postman
    #########################
    POSTMAN_EMAIL_ENDPOINT="https://postman.techseed.it/api/v3/postman"
    POSTMAN_SMS_URL="https://postman.techseed.it/api/v3/postman/sms"
    POSTMAN_KEY_ID=null
    POSTMAN_KEY_SECRET=null



### Configurazione Laravel ###

aggiungiamo al file **config/mail.php** nella sezione *mailers* il blocco

    'postman' => [
        'transport' => 'postman',
    ],


### impostazione di default ###

Per usarlo come driver principale per le mail, modificare il seguente parametro nel file **.env**

    MAIL_MAILER=postman # smtp | postman | log

Anche il parametro *MAIL_FROM_ADDRESS* di **.env** deve essere configurato in modo opportuno con un mittente abilitato all'invio per con credenziali inserite

