<?php

namespace JSM\Postman\Mail;

trait txdMailTrait
{
    /**
     * questi servono nella classe estesa per poter assegnare i vari attributi
     */
    protected $body = '';

    protected $arr_allegati = [];

    public function body($html_text)
    {
        $this->body = $html_text;
    }

    /**
     * da qui in poi iniziano attributi e metodi per gestire le funzionalita' aggiuntive
     */
    protected $send_as_raw = false;

    protected $override_message = false;

    /**
     * imposta gli attributi in modo da inviare la mail a Postman come Raw, eventualmente andando a sovrascrivere il contenuto della mail in fase di log
     *
     * @param  string  $override_message  [default "false"] se != "false" va a sovrascrivere il corpo del messaggio nei log
     * @return $this
     */
    public function sendAsRaw($override_message = false)
    {
        $this->send_as_raw = true;
        $this->override_message = $override_message;

        return $this;
    }

    protected $save_source_on_disk = false;

    protected $disk_name = '';

    protected $path_prefix = '';

    protected $override_message_with_path = false;

    public function saveSourceOnDisk($disk_name, $path_prefix = '', $override_message_with_path = false)
    {
        $this->save_source_on_disk = true;
        $this->disk_name = $disk_name;
        $this->path_prefix = $path_prefix;
        $this->override_message_with_path = $override_message_with_path;

        return $this;
    }

    /**
     * funzione di callback chiamata su un messaggio Swift
     * imposta alcuni parametri custom che ci serve salvare in fase di invio mail
     *
     * @param  type  $swift_message
     */
    public function fill_custom_attributes($message = null)
    {
        if (is_object($message)) {
            $message->custom_attributes['send_as_raw'] = $this->send_as_raw;
            $message->custom_attributes['override_message'] = $this->override_message;

            $message->custom_attributes['save_source_on_disk'] = $this->save_source_on_disk;
            $message->custom_attributes['disk_name'] = $this->disk_name;
            $message->custom_attributes['path_prefix'] = $this->path_prefix;
            $message->custom_attributes['override_message_with_path'] = $this->override_message_with_path;
        }
    }

    public function loadCallbacks()
    {
        $this->callbacks['custom_attributes'] = fn ($msg) => $this->fill_custom_attributes($msg);
    }
}
