<?php

namespace JSM\Postman;

//use Illuminate\Support\ServiceProvider;
use Illuminate\Mail\MailServiceProvider;
use Illuminate\Support\Facades\Mail;

class PostmanMailServiceProvider extends MailServiceProvider
{
    public function boot()
    {

        Mail::extend('postman', function (array $config = []) {
            $postman_config = config($config['service_config_path'] ?? 'services.postman', []);

            return new PostmanTransport(
                $postman_config['mail_endpoint'] ?? null,
                $postman_config['key'] ?? null,
                $postman_config['secret'] ?? null);
        });
    }
}
