<?php


if(!function_exists("add_ending_slash")){
    
    /**
     * aggiunge l'ultimo slash alla stringa se non e' gia' presente
     * 
     * @param string $dir_name
     * @param type $process_empty
     * @return string
     * @throws Exception
     */
    function add_ending_slash($dir_name, $process_empty = false){
        
        if(!is_string($dir_name)){
            throw new Exception("\$dirname must be a string");
        }
        
        if(strlen($dir_name) == 0 && !$process_empty){
            return "";
        }
        
        $last_char = mb_substr($dir_name, -1);
        
        if($last_char != "/" && $last_char != "\\"){
            $dir_name .= "/";
        }
        
        return $dir_name;
    }
}