<?php

/**
 * Created by Cristian.
 * Date: 05/09/16 11:27 PM.
 */

namespace Reliese\Coders\Model;

class txdRules{

    protected $name;
    protected $type;
    protected $original_type;
    protected $size;
    protected $unsigned;
    protected $autoincrement;
    protected $nullable;
    protected $default;
    protected $scale;

    protected $rule_required = false;
    protected $rule_type = null;
    protected $rule_max = null;

    public function __construct($column){

        foreach($column->getAttributes() as $key => $value){
            if(property_exists($this, $key)){
                $this->{$key} = $value;
            }
        }
    }


    protected function evaluate_mandatory(){

        if($this->nullable === false && $this->default === null){
            $this->rule_required = true;
        }else{
            $this->rule_required = false;
        }
    }

    protected function evaluate_type(){

        $nullable_string = ($this->nullable ? "_nullable" : "");

        switch($this->type){

            case "int":
                $this->rule_type = "integer".$nullable_string;
                break;

            case "date":
                $this->rule_type = "date".$nullable_string;
                break;

            case "float":
                $this->rule_type = "numeric".$nullable_string;
                break;

            default:
                // $this->rule_type = "string";
                break;
        }
    }

    protected static $int_size = [
        "tinyint" => 8,
        "smallint" => 16,
        "mediumint" => 24,
        "int" => 32,
        "bigint" => 64,
    ];

    protected function evaluate_size(){
        
        switch($this->type){
            case "int":
                //andiamo a valutare il tipo di dato originario
                $esponente = self::$int_size[$this->original_type] ?? 1;

                if($this->unsigned === false){
                    $esponente -= 1;
                }

                $this->rule_max = (2**$esponente) - 1 ;
            
                break;

            case "string":
            
                if(is_numeric($this->size)){
                    $this->rule_max = $this->size;
                }

                break;

            case "float":
            
                $decimal_part = $this->scale ?? 0;
                $int_part = $this->size - $decimal_part;

                $this->rule_max = (1**10^$int_part) - 1;
            
                break;

            default:
                $this->rule_max = null;
                break;
        }

    }

    public function generate_rule(){

        $rule_parts = [];

        $this->evaluate_mandatory();
        $this->evaluate_type();
        $this->evaluate_size();

        if($this->rule_required){
            $rule_parts[] = "required";
        }

        if($this->rule_type){
            $rule_parts[] = $this->rule_type;
        }

        if($this->rule_max){
            $rule_parts[] = "max:".$this->rule_max;
        }

        return join("|", $rule_parts);
    }

}