<?php

/**
 * Created by Cristian.
 * Date: 05/09/16 11:27 PM.
 */

namespace Reliese\Coders\Model;

class txdRules{

    protected $name;
    protected $type;
    protected $original_type;
    protected $size;
    protected $unsigned;
    protected $autoincrement;
    protected $nullable;
    protected $default;
    protected $scale;

    protected $current_model_obj;

    protected $rule_required = false;
    protected $rule_type = null;
    protected $rule_max = null;
    protected $rule_min = null;

    /**
     * 
     * @param \Illuminate\Support\Fluent $column
     * @param Model $model
     */
    public function __construct($column, $model){

        $this->current_model_obj = $model;

        foreach($column->getAttributes() as $key => $value){
            if(property_exists($this, $key)){
                $this->{$key} = $value;
            }
        }
    }


    protected function evaluate_mandatory(){

        if($this->nullable === false && $this->default === null){
            $this->rule_required = true;
        }else{
            $this->rule_required = false;
        }

        //se la chiave primaria e' autoincrement, non generiamo la regola di obbligatorieta' altrimenti fallisce il create
        if($this->current_model_obj->getPrimaryKey() == $this->name && $this->autoincrement){
            $this->rule_required = false;
        }
    }

    protected function evaluate_type(){

        $nullable_string = ($this->nullable ? "_nullable" : "");
        $nullable_prefix = ($this->nullable ? "nullable|" : "");

        switch($this->type){

            case "int":
                $this->rule_type = $nullable_prefix."integer";
                break;

            case "date":
                $this->rule_type = $nullable_prefix."date";
                break;

            case "float":
                $this->rule_type = $nullable_prefix."numeric";
                break;

            default:
                // $this->rule_type = "string";
                break;
        }

        if($this->original_type == "time"){
            $this->rule_type = $nullable_prefix."time";
        }
    }

    protected static $int_size = [
        "tinyint" => 8,
        "smallint" => 16,
        "mediumint" => 24,
        "int" => 32,
        "bigint" => 64,
    ];

    protected function evaluate_size(){
        
        switch($this->type){
            case "int":
                //andiamo a valutare il tipo di dato originario
                $esponente = self::$int_size[$this->original_type] ?? 1;

                if($this->unsigned === false){
                    $esponente -= 1;
                }

                $this->rule_max = (2**$esponente) - 1 ;

                if($this->unsigned){
                    $this->rule_min = 0;
                }else{
                    $this->rule_min = -($this->rule_max + 1);
                }
            
                break;

            case "string":
            
                if(is_numeric($this->size)){
                    $this->rule_max = $this->size;
                }

                break;

            case "float":
            
                $num_size = $this->size ?? null;
                $decimal_part = $this->scale ?? 0;

                if(is_numeric($num_size)){
                    $main_len = $num_size - $decimal_part;
                    $this->rule_max = str_pad("", $main_len, "9").".".str_pad("", ($decimal_part-1), "9")."5";
                }else{
                    if($this->original_type == "double"){
                        $this->rule_max = "1.7976931348623157E308";
                    }else{
                        $this->rule_max = "3.402823466E38";
                    }
                }

                if($this->unsigned){
                    $this->rule_min = 0;
                }else{
                    $this->rule_min = -($this->rule_max);
                }
            
                break;

            default:
                $this->rule_max = null;
                break;
        }

    }

    public function generate_rule(){

        $rule_parts = [];

        $this->evaluate_mandatory();
        $this->evaluate_type();
        $this->evaluate_size();

        if($this->rule_required){
            $rule_parts[] = "required";
        }

        if($this->rule_type){
            $rule_parts[] = $this->rule_type;
        }

        if($this->rule_max !== null){
            $rule_parts[] = "max:".$this->rule_max;
        }

        if($this->rule_min !== null){
            $rule_parts[] = "min:".$this->rule_min;
        }

        return join("|", $rule_parts);
    }

}