<?php

namespace Reliese\Coders\Console;

use Closure;

trait VersionTrait
{
    protected $version_messages = [];
    
    /**
     * Confirm before proceeding with the action.
     *
     * This method only asks for confirmation in production.
     *
     * @param  string  $warning
     * @param  \Closure|bool|null  $callback
     * @return bool
     */
    public function confirmToProceed($dest_file)
    {
        $this->version_messages = [];
        $callback = $this->compare_version($dest_file);

        $shouldConfirm = $callback instanceof Closure ? call_user_func($callback) : $callback;

        if ($shouldConfirm) {
            if ($this->option('force')) {
                return true;
            }

            $this->alert("Different Model Version!");

            $this->error($dest_file."\n");

            foreach($this->version_messages as $message){
                $this->comment($message);
            }

            $confirmed = $this->confirm('Do you really wish to run this command?');

            if (! $confirmed) {
                $this->comment('Command Cancelled!');

                return false;
            }
        }

        return true;
    }

    /**
     * Get the default confirmation callback.
     *
     * @return \Closure
     */
    protected function compare_version($dest_file)
    {
        return function () use ($dest_file) {
            $confirm_required = false;
            $model_version = "--";

            if(is_file($dest_file)){
                $old_file = fopen($dest_file, "r");
    
                //Output lines until EOF is reached
                while(! feof($old_file)) {
                    $line = fgets($old_file);
                    if(strpos($line, "--txdGeneratorVersion--") !== false){
                        $model_version = explode("--txdGeneratorVersion--", $line)[1] ?? "0";
                        break;
                    }
                }
    
                fclose($old_file);

                if($model_version !== \Reliese\Coders\CodersServiceProvider::$txdGeneratorVersion){
                    $this->version_messages[] = "Existing File Version: ".$model_version;
                    $this->version_messages[] = "New Version: ".\Reliese\Coders\CodersServiceProvider::$txdGeneratorVersion;
                    $confirm_required = true;
                }else{
                    $confirm_required = false;
                }
            }

            return $confirm_required;
        };
    }
}
