<?php

/**
 * Created by Cristian.
 * Date: 11/09/16 09:26 PM.
 */

namespace Reliese\Coders\Model\Relations;

use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Collection;

class HasMany extends HasOneOrMany
{
    /**
     * @return string
     */
    public function hint()
    {
        return '\\'.Collection::class.'|'.$this->related->getQualifiedUserClassName().'[]';
    }

    /**
     * @return string
     */
    public function name()
    {
        if(!is_string($this->parent->getRelationNameStrategy())){
            return $this->parent->getRelationNameStrategy()($this->related->getClassName());
        }
        switch ($this->parent->getRelationNameStrategy()) {
            case \Illuminate\Support\Str::startsWith($this->parent->getRelationNameStrategy(),"substitute|"):
                $relationName = explode("|",$this->parent->getRelationNameStrategy())[1];
                $className = $this->related->getClassName();
                $relationName = str_replace(":Model",\Illuminate\Support\Str::studly($className),$relationName);
                $relationName = str_replace(":model",\Illuminate\Support\Str::snake($className),$relationName);
                return $relationName;
            case 'foreign_key':
                $relationName = RelationHelper::stripSuffixFromForeignKey(
                    $this->parent->usesSnakeAttributes(),
                    $this->localKey(),
                    $this->foreignKey()
                );
                if (Str::snake($relationName) === Str::snake($this->parent->getClassName())) {
                    $relationName = Str::plural($this->related->getClassName());
                } else {
                    $relationName = Str::plural($this->related->getClassName()) . 'Where' . ucfirst(Str::singular($relationName));
                }
                break;
            default:
            case 'related':
                $relationName = Str::plural($this->related->getClassName());
                break;
        }

        if ($this->parent->usesSnakeAttributes()) {
            return Str::snake($relationName);
        }

        return Str::camel($relationName);
    }

    /**
     * @return string
     */
    public function method()
    {
        return 'hasMany';
    }
}
