<?php

/**
 * Created by Cristian.
 * Date: 11/09/16 09:26 PM.
 */

namespace Reliese\Coders\Model\Relations;

use Illuminate\Support\Str;

class HasOne extends HasOneOrMany
{
    /**
     * @return string
     */
    public function hint()
    {
        return $this->related->getQualifiedUserClassName();
    }

    /**
     * @return string
     */
    public function old_name()
    {
        if ($this->parent->usesSnakeAttributes()) {
            return Str::snake($this->related->getClassName());
        }

        return Str::camel($this->related->getClassName());
    }
    public function name()
    {
        if(!is_string($this->parent->getRelationNameStrategy())){
            return $this->parent->getRelationNameStrategy()($this->related->getClassName());
        }
        switch ($this->parent->getRelationNameStrategy()) {
            case \Illuminate\Support\Str::startsWith($this->parent->getRelationNameStrategy(),"substitute|"):
                $relationName = explode("|",$this->parent->getRelationNameStrategy())[1];
                $className = $this->related->getClassName();
                $relationName = str_replace(":Model",\Illuminate\Support\Str::studly($className),$relationName);
                $relationName = str_replace(":model",\Illuminate\Support\Str::snake($className),$relationName);
                return $relationName;
            case 'foreign_key':
                $relationName = RelationHelper::stripSuffixFromForeignKey(
                    $this->parent->usesSnakeAttributes(),
                    $this->localKey(),
                    $this->foreignKey()
                );
                if (Str::snake($relationName) === Str::snake($this->parent->getClassName())) {
                    $relationName = Str::plural($this->related->getClassName());
                } else {
                    $relationName = Str::plural($this->related->getClassName()) . 'Where' . ucfirst(Str::singular($relationName));
                }
                break;
            default:
            case 'related':
                $relationName = Str::plural($this->related->getClassName());
                break;
        }

        if ($this->parent->usesSnakeAttributes()) {
            return Str::snake($relationName);
        }

        return Str::camel($relationName);
    }

    public function body(){
        $body = '/** @var \Illuminate\Database\Eloquent\Model */'."\n";
        $body .='$self = $this;'."\n";
        $body .='if(!is_null($prop)){
    $relation = $self->{__FUNCTION__};
    if(Illuminate\Support\Str::endsWith($prop,"()")){
        $method = str_Replace("()","",$prop);
        return optional($relation)->{$method}();
    }
    return optional($relation)->{$prop};
}'."\n";
        return $body.parent::body();
    }

    /**
     * @return string
     */
    public function method()
    {
        return 'hasOne';
    }
    public function params(){
        return ["prop" => "null", "withPermissions" => "true"];
    }
}
