<?php

namespace Txd\Api\Clients\Auth;

use Illuminate\Support\Facades\Cache;

class OauthClientCredentialsStrategy extends AbstractOauthStrategy
{
    public function __construct(
        protected array $config
    ) {}

    public function cacheDiscriminator(): string
    {
        return 'oauth.client_credentials.'.($this->config['client_id'] ?? 'default');
    }

    // --------------------------------------------------
    // Token management
    // --------------------------------------------------

    protected function getAccessToken(): TokenStore
    {
        return TokenStore::fromArray(Cache::remember(
            $this->accessTokenKey(),
            60, // fallback TTL, will be replaced by expires_in
            function () {
                return $this->refreshAccessToken()->toArray();
            }
        ));
    }

    protected function storeAccessToken(TokenStore $store): void
    {
        Cache::set(
            $this->accessTokenKey(),
            $store->toArray(),
            $store->expires_in ?? 60 // fallback TTL, will be replaced by expires_in
        );
    }

    protected function refreshTokenPayload(): array
    {
        return [
            'grant_type' => 'client_credentials',

        ];
    }

    // --------------------------------------------------
    // Cache keys
    // --------------------------------------------------

    protected function accessTokenKey(): string
    {
        return 'oauth.access.'.hash('sha256', $this->config['client_id']);
    }
}
