<?php

namespace Txd\Api\Clients\Pipes;

use Prewk\Result;
use Txd\Api\Clients\Contracts\RequestPipe;
use Txd\Api\Clients\RequestParams;

class AsJson implements RequestPipe
{
    public $order = 100;

    public function __construct(protected bool $associative = true) {}

    public function order(): int
    {
        return $this->order;
    }

    public function handle(RequestParams $request, $next): Result
    {

        $response = $next($request);

        if ($response->isOk()) {
            return Ok(json_decode($response->unwrap(), $this->associative));

        }

        return $response;

    }
}
