<?php

namespace Txd\Api\Clients\Pipes;

use Closure;
use Prewk\Result;
use Txd\Api\Clients\Contracts\RequestPipe;
use Txd\Api\Clients\RequestParams;

class ClientMutator implements RequestPipe
{
    public int $order;

    /**
     * @param  Closure(PendingRequest)  $callback
     * @return void
     */
    public function __construct(protected Closure $callback, ?int $order = null)
    {
        $this->order = $order;
    }

    public function handle(RequestParams $request, $next): Result
    {
        ($this->callback)($request->request);

        return $next($request);

    }

    public function order(): int
    {
        return $this->order;
    }
}
