<?php

namespace Txd\Api\Clients\Auth;

class TokenStore
{
    public function __construct(
        public readonly string $access_token,
        public readonly ?string $refresh_token = null,
        public readonly ?string $expires_in = null,
        public readonly ?array $metadata = null) {}

    public static function fromArray(array $args)
    {
        return new static($args['access_token'],$args['refresh_token'] ?? null, $args['expires_in'] ?? $args['expires'] ?? null,$args['metadata'] ?? null);
    }

    public function toArray()
    {
        return [
            'access_token' => $this->access_token,
            'refresh_token' => $this->refresh_token,
            'expires_in' => $this->expires_in,
            'metadata' => $this->metadata,
        ];
    }
}
