<?php

namespace Txd\Api\Clients\Pipes;

use Prewk\Result;
use Txd\Api\Clients\Contracts\RequestPipe;
use Txd\Api\Clients\RequestParams;
use Txd\Api\Clients\ResponseResult;

class AsJson implements RequestPipe
{
    public $order = 100;

    public function __construct(protected bool $associative = true) {}

    public function order(): int
    {
        return $this->order;
    }

    public function handle(RequestParams $request, $next): ResponseResult
    {
        $request->request->acceptJson();
        $response = $next($request);

        if ($response->isOk()) {
            return ResponseResult::fromResponse(Ok(json_decode($response->unwrap(), $this->associative)),$response->rawResponse());

        }

        return $response;

    }
}
