<?php

namespace Txd\Api\Clients\Auth;

use Closure;
use Exception;

class OauthAccessTokenStrategy extends AbstractOauthStrategy
{
    public function __construct(
        protected array $config,
        protected ?Closure $accessTokenGetter = null,
        protected ?Closure $accessTokenSetter = null

    ) {}

    public function cacheDiscriminator(): string
    {
        return 'oauth.personal.'.substr(
            hash('sha256', $this->getAccessToken()->access_token),
            0,
            12
        );
    }

    // --------------------------------------------------
    // Token management
    // --------------------------------------------------

    protected ?TokenStore $_current = null;

    protected function getAccessToken(): TokenStore
    {
        if (is_null($this->_current)) {

            if (is_null($this->accessTokenGetter)) {
                throw new Exception(__CLASS__.' | AccessTokenGetter not defined');
            }
            $this->_current = ($this->accessTokenGetter)();
        }

        return $this->_current;
    }

    protected function storeAccessToken(TokenStore $store): void
    {
        if (!is_null($this->accessTokenSetter)) {
            ($this->accessTokenSetter)($store);
        } else {
            \Log::warning(__CLASS__.'|'.__METHOD__.'| accessTokenSetter not set, the access token will not be persisted');
        }
        $this->_current = $store;
    }

    protected function refreshTokenPayload(): ?array
    {
        $tokenStore = $this->getAccessToken();
        if (is_null($tokenStore->refresh_token)) {
            return null;
        }

        return [
            'grant_type' => 'refresh_token',
            'refresh_token' => $tokenStore->refresh_token,
        ];
    }
}
