<?php

namespace Txd\Api\Clients\Auth;

class TokenStore
{
    public function __construct(
        public readonly string $access_token,
        public readonly ?string $refresh_token = null,
        public readonly ?string $expires_at = null,
        public readonly ?array $metadata = null) {}

    public static function fromArray(array $args)
    {
        $expires_at = match(true){
            array_key_exists("expires_at",$args) => $args["expires_at"],
            array_key_exists("expires",$args) => $args["expires"],
            array_key_exists("expires_in",$args) => now()->timestamp + $args["expires_in"],
            default => null
        };
        
        
        return new static(
            $args['access_token'],
            $args['refresh_token'] ?? null,
             $expires_at,
             $args['metadata'] ?? null
        );
    }

    public function toArray()
    {
        return [
            'access_token' => $this->access_token,
            'refresh_token' => $this->refresh_token,
            'expires_at' => $this->expires_at,
            'metadata' => $this->metadata,
        ];
    }
}
