<?php

namespace Txd\Api\Clients;

use Exception;
use \Illuminate\Http\Client\Response;
use Prewk\Option;
use Prewk\Result;

class ResponseResult extends Result
{
    public function __construct(
        protected Result $value,
        protected ?Response $response,
        protected array $headers,
        protected int $status,
        ) {}
        
    public static function fromResponse(Result $value, Response $response){
        return new static($value,$response,$response->getHeaders(),$response->status());
    }

    public function isOk(): bool
    {
        return $this->value->isOk(...func_get_args());
    }

    public function isErr(): bool
    {
        return $this->value->isErr(...func_get_args());
    }

    public function ok(): Option
    {
        return $this->value->ok(...func_get_args());
    }

    public function err(): Option
    {
        return $this->value->err(...func_get_args());
    }

    public function map(callable $mapper): Result
    {
        return $this->value->map(...func_get_args());
    }

    public function mapOr($default, callable $f): mixed
    {
        return $this->value->mapOr(...func_get_args());
    }

    public function mapOrElse(callable $default, callable $f): mixed
    {
        return $this->value->mapOrElse(...func_get_args());
    }

    public function mapErr(callable $op): Result
    {
        return $this->value->mapErr(...func_get_args());
    }

    public function inspect(callable $f): Result
    {
        return $this->value->inspect(...func_get_args());
    }

    public function inspectErr(callable $f): Result
    {
        return $this->value->inspectErr(...func_get_args());
    }

    public function iter(): iterable
    {
        return $this->value->iter(...func_get_args());
    }

    public function expect(Exception $msg): mixed
    {
        return $this->value->expect(...func_get_args());
    }

    public function unwrap(): mixed
    {
        return $this->value->unwrap(...func_get_args());
    }

    public function expectErr(Exception $msg): mixed
    {
        return $this->value->expectErr(...func_get_args());
    }

    public function unwrapErr(): mixed
    {
        return $this->value->unwrapErr(...func_get_args());
    }

    public function and(Result $res): Result
    {
        return $this->value->and(...func_get_args());
    }

    public function andThen(callable $op): Result
    {
        return $this->value->andThen(...func_get_args());
    }

    public function or(Result $res): Result
    {
        return $this->value->or(...func_get_args());
    }

    public function orElse(callable $op): Result
    {
        return $this->value->orElse(...func_get_args());
    }

    public function unwrapOr($optb): mixed
    {
        return $this->value->unwrapOr(...func_get_args());
    }

    public function unwrapOrElse(callable $op): mixed
    {
        return $this->value->unwrapOrElse(...func_get_args());
    }
        
    /**
     * response may be null if request was cached
     * @return null|Response 
     */
    public function rawResponse(){
        return $this->response;
    }
    
    public function headers()
    {
        return $this->headers;
    }

    /**
     * Get the status code of the response.
     *
     * @return int
     */
    public function status()
    {
        return $this->status;
    }
}
