<?php

namespace Txd\Api\Clients\Pipes;

use Closure;
use Illuminate\Http\Client\PendingRequest;
use Prewk\Result;
use Txd\Api\Clients\Contracts\RequestPipe;
use Txd\Api\Clients\RequestParams;
use Txd\Api\Clients\ResponseResult;

class ClientMutator implements RequestPipe
{
    public int $order;

    /**
     * @param  Closure(PendingRequest)  $callback
     * @return void
     */
    public function __construct(protected Closure $callback, ?int $order = null)
    {
        $this->order = $order;
    }

    public function handle(RequestParams $request, $next): ResponseResult
    {
        ($this->callback)($request->request);

        return $next($request);

    }

    public function order(): int
    {
        return $this->order;
    }
}
