<?php

namespace Txd\Api\Clients\Pipes;

use Prewk\Result;
use Txd\Api\Clients\Contracts\RequestPipe;
use Txd\Api\Clients\RequestParams;
use Txd\Api\Clients\ResponseResult;

use function Illuminate\Filesystem\join_paths;

class FromPath implements RequestPipe
{
    public $order = 20;

    protected array $path = [];
    public function __construct(string|array $path) {
        if (is_string($path)) {
            $path = [$path];
        }
        
        $this->path = $path;
    }

    public function order(): int
    {
        return $this->order;
    }
    
    protected function basePath(string|array $path)
    {
        if (is_string($path)) {
            $path = [$path];
        }

        return join_paths(...$this->path, ...$path);
    }

    public function handle(RequestParams $request, $next): ResponseResult
    {
        $request->path = $this->basePath($request->path);
        
        return $next($request);

        

    }
}
