<?php

namespace Txd\Api\Clients\Auth;

use Closure;
use Illuminate\Http\Client\PendingRequest;
use Txd\Api\Clients\Contracts\AuthStrategy;
use Txd\Api\Clients\HttpClient;
use TypeError;

class AuthorizationHeaderStrategy implements AuthStrategy {
    
    public function __construct(protected string|Closure $token, protected string $scheme = "Bearer")
    {
        
    }
    
    public function authenticate(PendingRequest $request): PendingRequest
    {
        $token = $this->token;
        if(is_a($token,Closure::class)){
            $token = $token();
        }
        
        if(!is_string($token)){
            $type = gettype($token);
            throw new TypeError(__METHOD__."| the token must be a string, {$type}");
        }
        
        return $request->withToken($this->token);
    }

    public function handleUnauthorized(HttpClient $client): bool
    {
        false;
    }

    public function cacheDiscriminator(): string
    {
        $token = $this->token;
        if(is_a($token,Closure::class)){
            $token = $token();
        }
        
        if(!is_string($token)){
            $type = gettype($token);
            throw new TypeError(__METHOD__."| the token must be a string, {$type}");
        }
        return "authHeader.{$this->scheme}.".substr(
            hash('sha256', $token),
            0,
            12
        );
    }
    
}