<?php

namespace Txd\Api\Clients\Auth;

use Carbon\Carbon;
use Illuminate\Support\Facades\Cache;

class OauthClientCredentialsStrategy extends AbstractOauthStrategy
{
    public function __construct(
        protected array $config
    ) {}

    public function cacheDiscriminator(): string
    {
        return 'oauth.client_credentials.'.($this->config['client_id'] ?? 'default');
    }

    // --------------------------------------------------
    // Token management
    // --------------------------------------------------

    protected function getAccessToken(): TokenStore
    {
        if(!Cache::has($this->accessTokenKey())){
            return new TokenStore("");
        }
        
        return TokenStore::fromArray(Cache::get(
            $this->accessTokenKey()
        ));
    }

    protected function storeAccessToken(TokenStore $store): void
    {
        Cache::set(
            $this->accessTokenKey(),
            $store->toArray(),
            is_null($store->expires_at) ? 60:now()->diffInSeconds(Carbon::createFromTimestamp($store->expires_at)) ?? 60
        );
    }

    protected function refreshTokenPayload(): array
    {
        return [
            'grant_type' => 'client_credentials',

        ];
    }

    // --------------------------------------------------
    // Cache keys
    // --------------------------------------------------

    protected function accessTokenKey(): string
    {
        return 'oauth.access.'.hash('sha256', $this->config['client_id']);
    }
}
