<?php

namespace Txd\Api\Clients\Pipes;

use Illuminate\Http\Client\RequestException;
use Prewk\Result;
use Txd\Api\Clients\Contracts\RequestPipe;
use Txd\Api\Clients\RequestParams;
use Txd\Api\Clients\ResponseResult;

class Throws implements RequestPipe
{
    public $order = 100;

    public function __construct() {}

    public function handle(RequestParams $request, $next): ResponseResult
    {
        $fullErrors = method_exists(RequestException::class,"dontTruncate");
        try{
            if($fullErrors){
                $default = RequestException::$truncateAt;
                RequestException::dontTruncate();
            }
            $response = $next($request);
            if(!$response->rawResponse()->ok()){
                $response->rawResponse()->throw();
            }
            return $response;
        }finally{
            if($fullErrors && $default){
                RequestException::truncateAt($default);
            }
        }
        
        
    }

    public function order(): int
    {
        return $this->order;
    }
}
