<?php

namespace txd\ExportJobsManager\Controllers;

use \App\Http\Controllers\Controller;

class txdExportManagerController extends Controller{

    protected $documentazione_attiva = false;

    public function retrieve_exported_file($key = null){

        /*
		 * log documentazione
		 */
		if(class_exists("jsmDoc")){

			try{
				\jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__);
				$this->documentazione_attiva = true;
			}catch(\Exception $ex){
				\Log::error(__FILE__." | ".__FUNCTION__." | Errore creazione documentazione: ".$ex->getMessage());
			}
		}

        if($this->documentazione_attiva){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

        $obj = new \txd\ExportJobsManager\txdExportManager("PDF");

        switch ($obj->job_type) {
            case 'Excel':
                $estensione = ".pdf";
                break;

            case 'PDF':
                $estensione = ".pdf";
                break;
            
            default:
                $estensione = ".null";
                break;
        }

        if(strlen($key) == 0){
            $key = $obj->job_prefix;
        }

        \Storage::disk($obj->disk_name)->getAdapter()->setPathPrefix($obj->out_dir);
        return download_disk_file($obj->disk_name, $key.$estensione, "", false);
    }

}