<?php

namespace txd\ExportJobsManager\Provider;

use Illuminate\Support\ServiceProvider;
use txd\ExportJobsManager\ETMClient as ETMETMClient;

/**
 *  *
 * @author Fabio Spadea <fabio@techseed.it>
 */
class ExportJobsManagerServiceProvider extends ServiceProvider
{

    /**
     * Boot the service provider.
     *
     * @return void
     */
    public function boot()
    {
        if (false !== strpos($this->app->version(), 'Lumen')) {
            $this->app->configure('txd_export_jobs_manager');
        } else {
            // Publish config files
            $this->publishes([
                __DIR__ . '/../../config/txd_export_jobs_manager.php' => config_path('txd_export_jobs_manager.php'),
            ], 'config');
        }

        $this->mergeConfigFrom(
			__DIR__.'/../../config/txd_export_jobs_manager.php', 'txd_export_jobs_manager'
        );
        
        \Route::group([
			'middleware' => 'web',
		], function ($router){
			require __DIR__.'/../routes/web.php';
		});

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        
    }

}
