<?php

namespace txd\ExportJobsManager\Controllers;

use \App\Http\Controllers\Controller;
use \txd\ExportJobsManager\txdExportManager;

class txdExportManagerController extends Controller{

    protected $documentazione_attiva = false;

    public function retrieve_exported_file($type, $key = null){

        /*
		 * log documentazione
		 */
		if(class_exists("jsmDoc")){

			try{
				\jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__);
				$this->documentazione_attiva = true;
			}catch(\Exception $ex){
				\Log::error(__FILE__." | ".__FUNCTION__." | Errore creazione documentazione: ".$ex->getMessage());
			}
		}

        if($this->documentazione_attiva){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

        switch ($type) {
            case 'Excel':
                $type = "Excel";
                break;

            case 'PDF':
                $type = "PDF";
                break;
            
            default:
                throw new \Exception(__METHOD__." | JOB Type not supported ".$type);
        }

        $obj = new txdExportManager($type);

        $estensione = $obj->estensione_file;

        if(strlen($key) == 0){
            $key = $obj->job_prefix;
        }

        \Storage::disk($obj->disk_name)->getAdapter()->setPathPrefix($obj->out_dir);


        if($estensione == ".pdf" && txdExportManager::$show_in_browser){
            return \Response::make(\Storage::disk($obj->disk_name)->get($key.$estensione), 200, [
                'Content-Type' => 'application/pdf',
                'Content-Disposition' => 'inline; filename="'.$key.$estensione.'"'
            ]);
        }else{
            return download_disk_file($obj->disk_name, $key.$estensione, "", !txdExportManager::$show_in_browser);
        }

    }

}