<?php

namespace txd\ExportJobsManager\Controllers;

use \App\Http\Controllers\Controller;
use \txd\ExportJobsManager\txdExportManager;

class txdExportManagerController extends Controller{

    protected $documentazione_attiva = false;

    protected $controller_name;
    protected $method_name;
    protected $request_pars;
    protected $controller_pars;
    protected $pdf_orientation = "Portrait";
    protected $tipo_export = "PDF";

    /**
     *
     * @var \txd\ExportJobsManager\ModuleConfig\pdfConfig
     */
    public $existing_pdf_config;


    public function generate_url(){
        \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__);

        $invocable_par = [
            "controller" => $this->controller_name,
            "method" => $this->method_name,
            "request" => $this->request_pars,
            "pars" => $this->controller_pars,
            "orientation" => $this->pdf_orientation,
            "tipo_export" => $this->tipo_export,
            "existing_pdf_config" => $this->existing_pdf_config,
        ];
        
        // dd($request, $invocable_par);

        $session_key = sha1(microtime(true).\Webpatser\Uuid\Uuid::generate(4)->string);

        session()->put("invocable_jobs.".$session_key, $invocable_par);

        return route("txd_export_jobs.landing_export", [$session_key]);
    }

    public function landing_export($session_key){
        \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__);

        // session()->put("invocable_jobs.".$session_key.".request", request()->input());

        return view(config("txd_export_jobs_manager.landing_export_view"), ["session_key" => $session_key]);
    }


    public function start_export($session_key){
        \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__);

        $info = session("invocable_jobs.".$session_key);

        request()->merge($info["request"] ?? []);

        $controller = new $info["controller"]();
        $method = $info["method"];
        $pars  = $info["pars"] ?? [];
        $tipo_export  = $info["tipo_export"] ?? "PDF";
        $existing_pdf_config  = $info["existing_pdf_config"] ?? null;

        // $report_obj = $controller->{$method}();
        $report_obj = call_user_func_array(array($controller, $method), $pars);

        $html_view = $report_obj->html_pagina;
        $html_header = $report_obj->html_header ?? null;
        $html_footer = $report_obj->html_footer ?? null;

        $export_job = new \txd\ExportJobsManager\txdExportManager($tipo_export);

        if(is_a($existing_pdf_config, \txd\ExportJobsManager\ModuleConfig\pdfConfig::class)){
            $export_job->set_pdf_config($existing_pdf_config);
        }

        $export_job->get_pdf_config()->orientation($info["orientation"] ?? "Portrait");
        $export_job->add_source_content($html_view);
        
        if($html_header !== null){
            $export_job->add_pdf_header($html_header);
        }
        if($html_footer !== null){
            $export_job->add_pdf_footer($html_footer);
        }

        $export_job->start();

        $out = ["stato" => "OK", "prefix" => $export_job->job_prefix, "session_key" => $session_key];

        return json_encode($out);

    }

    public function check_export(){
        \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__);

        $prefix = request()->input("prefix");
        $session_key = request()->input("session_key");

        $info = session("invocable_jobs.".$session_key);
        $tipo_export  = $info["tipo_export"] ?? "PDF";
        
        $export_job = new \txd\ExportJobsManager\txdExportManager($tipo_export);

        $completed = $export_job->job_terminated($prefix);
        $out = [
            "completed" => $completed,
            "pdf_url" => $completed ? route("txd_export_jobs.retrieve_exported_file", [$tipo_export, $prefix]) : "",
        ];

        return json_encode($out);
    }



    public function retrieve_exported_file($type, $key = null){

        /*
		 * log documentazione
		 */
		if(class_exists("jsmDoc")){

			try{
				\jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__);
				$this->documentazione_attiva = true;
			}catch(\Exception $ex){
				\Log::error(__FILE__." | ".__FUNCTION__." | Errore creazione documentazione: ".$ex->getMessage());
			}
		}

        if($this->documentazione_attiva){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

        switch ($type) {
            case 'Excel':
                $type = "Excel";
                break;

            case 'PDF':
                $type = "PDF";
                break;
            
            default:
                throw new \Exception(__METHOD__." | JOB Type not supported ".$type);
        }

        $obj = new txdExportManager($type);

        $estensione = $obj->estensione_file;

        if(strlen($key) == 0){
            $key = $obj->job_prefix;
        }

        \Storage::disk($obj->disk_name)->getAdapter()->setPathPrefix($obj->out_dir);


        if($estensione == ".pdf" && txdExportManager::$show_in_browser){
            return \Response::make(\Storage::disk($obj->disk_name)->get($key.$estensione), 200, [
                'Content-Type' => 'application/pdf',
                'Content-Disposition' => 'inline; filename="'.$key.$estensione.'"'
            ]);
        }else{
            return download_disk_file($obj->disk_name, $key.$estensione, "", !txdExportManager::$show_in_browser);
        }

    }




    /**
     *
     * @param mixed $val
     * @return txdExportManagerController|string
     */
    public function controller_name($val = null){
        if(is_null($val)){
            return $this->controller_name;
        }else{
            $this->controller_name = $val;
            return $this;
        }
    }

    /**
     *
     * @param mixed $val
     * @return txdExportManagerController|string
     */
    public function method_name($val = null){
        if(is_null($val)){
            return $this->method_name;
        }else{
            $this->method_name = $val;
            return $this;
        }
    }

    /**
     *
     * @param mixed $val
     * @return txdExportManagerController|string
     */
    public function request_pars($val = null){
        if(is_null($val)){
            return $this->request_pars;
        }else{
            $this->request_pars = $val;
            return $this;
        }
    }

    /**
     *
     * @param mixed $val
     * @return txdExportManagerController|string
     */
    public function controller_pars($val = null){
        if(is_null($val)){
            return $this->controller_pars;
        }else{
            $this->controller_pars = $val;
            return $this;
        }
    }

    /**
     *
     * @param mixed $val
     * @return txdExportManagerController|string
     */
    public function pdf_orientation($val = null){
        if(is_null($val)){
            return $this->pdf_orientation;
        }else{
            $this->pdf_orientation = $val;
            return $this;
        }
    }

    /**
     *
     * @param mixed $val
     * @return txdExportManagerController|string
     */
    public function tipo_export($val = null){
        if(is_null($val)){
            return $this->tipo_export;
        }else{
            $this->tipo_export = $val;
            return $this;
        }
    }
}