<?php

namespace txd\ExportJobsManager\Excel;

class txdExcelGrid{

    protected $documentazione_attiva = false;

    protected $source;
    protected $columns = [];
    protected $table_data = [];

    public function __construct($source) {

        /*
		 * log documentazione
		 */
		if(class_exists("jsmDoc")){

			try{
				\jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__);
				$this->documentazione_attiva = true;
			}catch(\Exception $ex){
				\Log::error(__FILE__." | ".__FUNCTION__." | Errore creazione documentazione: ".$ex->getMessage());
			}
        }
        
        $this->source = $source;
    }


    public function __call($name, $arguments){
        //in questo modo tutti i metodi che non andiamo a definire verranno catturati qui senza dare errori
    }




    /**
     * 
     *
     * @param string $nome_campo
     * @param string $label
     * @return txdExcelColumn
     */
    public function add($nome_campo, $label=""){

        if($this->documentazione_attiva){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

        $column_obj = new txdExcelColumn($nome_campo, $label);
        $this->columns[] = $column_obj;

        return $column_obj;
    }


    public function build(){
        if($this->documentazione_attiva){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

        //processiamo le intestazioni
        $header = [];

        foreach($this->columns as $item){
            $header[] = $item->label;
        }

        $this->table_data[] = $header;

        
        //quindi andiamo a popolare i dati
        $data_arr = [];
        if(is_a($this->source, \Illuminate\Database\Eloquent\Builder::class) || is_a($this->source, \Illuminate\Database\Query\Builder::class)){
            $data_arr = $this->source->get();
        }else{
            $data_arr = $this->source;
        }

        foreach($data_arr as $source_item){
            $row = [];
            foreach($this->columns as $item){
                $cell = $item->build_value($source_item);

                if(!is_a($cell, txdRemovableCell::class)){
                    $row[] = $cell;
                }
            }

            $this->table_data[] = $row;
        }
        
        // echo json_encode($this->table_data);
        // die();
        jddd($this->table_data);
    }
}