<?php

namespace txd\ExportJobsManager\ModuleConfig;

class pdfConfig implements \JsonSerializable {
    
    

    protected $json_config = [];

    public function __construct()
    {
        $this->json_config["page-size"] = config("txd_export_jobs_manager.page-size", "A4");
        $this->json_config["margin-top"] = config("txd_export_jobs_manager.margin-top", "0.4in");
        $this->json_config["margin-right"] = config("txd_export_jobs_manager.margin-right", "0.4in");
        $this->json_config["margin-bottom"] = config("txd_export_jobs_manager.margin-bottom", "0.4in");
        $this->json_config["margin-left"] = config("txd_export_jobs_manager.margin-left", "0.4in");
        $this->json_config["encoding"] = config("txd_export_jobs_manager.encoding", "UTF-8");
        $this->json_config["no-outline"] = null;
        $this->json_config["orientation"] = config("txd_export_jobs_manager.orientation", "Portrait");
    }

    
    public function jsonSerialize() {  
        return $this->json_config;
    }

    public function toArray(){
        return $this->json_config;
    }

    public function page_size($val = "A4"){
        $this->json_config["page-size"] = $val;
        return $this;
    }
    public function margin_top($val = "0.4in"){
        $this->json_config["margin-top"] = $val;
        return $this;
    }
    public function margin_bottom($val = "0.4in"){
        $this->json_config["margin-bottom"] = $val;
        return $this;
    }
    public function margin_right($val = "0.4in"){
        $this->json_config["margin-right"] = $val;
        return $this;
    }
    public function margin_left($val = "0.4in"){
        $this->json_config["margin-left"] = $val;
        return $this;
    }
    public function encoding($val = "UTF-8"){
        $this->json_config["encoding"] = $val;
        return $this;
    }
    public function no_outline($val = null){
        $this->json_config["no-outline"] = $val;
        return $this;
    }
    public function orientation($val = "Portrait"){
        $this->json_config["orientation"] = $val;
        return $this;
    }

    public function add_custom_option($name, $val){
        $this->json_config[$name] = $val;
        return $this;
    }

}