<?php

namespace txd\ExportJobsManager\Excel;

class txdExcelColumn{


    protected $documentazione_attiva = false;

    protected $nome_campo;
    public $label;
    public $content;
    protected $cell_callable;

    public function __construct($nome_campo, $label = "") {
        /*
		 * log documentazione
		 */
		if(class_exists("jsmDoc")){

			try{
				\jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__);
				$this->documentazione_attiva = true;
			}catch(\Exception $ex){
				\Log::error(__FILE__." | ".__FUNCTION__." | Errore creazione documentazione: ".$ex->getMessage());
			}
        }
        
        $this->nome_campo = $nome_campo;
        $this->label = $label;
    }


    public function __call($name, $arguments){
        //in questo modo tutti i metodi che non andiamo a definire verranno catturati qui senza dare errori
    }



    /**
     * 
     *
     * @param \Closure $callable
     * @return txdExcelColumn
     */
    public function cell(\Closure $callable){
        if($this->documentazione_attiva){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

        $this->cell_callable = $callable;

        return $this;
    }


    public function build_value($item){
        if($this->documentazione_attiva){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
        
        if ($this->cell_callable) {
            $callable = $this->cell_callable;
            $value = $callable($item->{$this->nome_campo}, $item);
            
            if(is_a($value, txdExcelCell::class)){
                $out = $value;

            }elseif(is_string($value)){
                $out = html_entity_decode(strip_tags($value));

            }elseif(is_object($value)){
                $out = new txdRemovableCell(); //se non e' di un tipo "supportato" marchiamola come da rimuovere (verra' tolta l'intera colonna)
            }else{
                $out = $value;
            }

            return $out;

        }elseif(strpos($this->nome_campo, ".") !== false){ //e' un metodo di relazione

            $parts = explode(".", $this->nome_campo);

            foreach($parts as $p){
                $item = is_object($item) ? $item->{$p} : null;
            }

            return $item;

        }else{
            return $item->{$this->nome_campo};
        }
    }

}