<?php
namespace Txd\FieldTypes;
/**
 * Checkbox con Sì/No in visualizzazione e bottone di info aggiuntivo
 */
class Checkbox extends \Txd\FieldTypes\Text {
    public function __construct($nome, $etichetta = "", $classi_html = []){
        parent::__construct($nome,$etichetta, $classi_html);
    }

    public function parse_valore($valore) {
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
        
        return $valore==1?"Sì":"No";
    }

    public function build_view(){
        return "<div>".$this->get_valore()."</div>";
    }

    public function build_edit(){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
        return view("txd::FieldTypes.CheckBox",["campo_obj"=>$this]);
    }

}