/**
 * @name txdDatePicker
 * @author sabba <francesco@techseed.it>
 * @version 1.0.1.0
 * 
 * using 
 * Pikaday jQuery plugin.
 * Copyright © 2013 David Bushell | BSD & MIT license | https://github.com/Pikaday/Pikaday* 
 * 
 *  moment.js 
 *   GitHub: https://github.com/moment/moment/
 *	License: https://raw.githubusercontent.com/moment/moment/develop/LICENSE
 */

(function (root, factory)
{
    'use strict';

    factory(root.jQuery, root.Pikaday,root.TimePicker);
    
}(this, function ($, Pikaday, TimePicker)
{
    'use strict';

    $.fn.pikaday = function()
    {
        var args = arguments;

        if (!args || !args.length) {
            args = [{ }];
        }

        return this.each(function()
        {
            let default_languages = {
                en:{
                    previousMonth : 'Previous Month',
                    nextMonth     : 'Next Month',
                    months        : ['January','February','March','April','May','June','July','August','September','October','November','December'],
                    weekdays      : ['Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday'],
                    weekdaysShort : ['Sun','Mon','Tue','Wed','Thu','Fri','Sat']
                },
                it:{
                    previousMonth : 'Mese Precedente',
                    nextMonth     : 'Mese Successivo',
                    months        : ['Gennaio','Febbraio','Marzo','Aprile','Maggio','Giugno','Luglio','Agosto','Settembre','Ottobre','Novembre','Dicembre'],
                    weekdays      : ['Domenica','Luned&igrave;','Marted&igrave;','Mercoled&igrave;','Gioved&igrave;','Venerd&igrave;','Sabato'],
                    weekdaysShort : ['Dom','Lun','Mar','Mer','Gio','Ven','Sab']
                }
            };
            let default_override_options = {
                format:"DD/MM/YYYY",
                i18n: default_languages.it,
                yearRange:80
            };

            var self   = $(this),
                plugin = self.data('pikaday');
            if (plugin === undefined||!(plugin instanceof Pikaday)) {
                if (typeof args[0] === 'object') {
                    var options = $.extend(default_override_options, args[0]);
                    options.field = self[0];
                    self.data('pikaday', new Pikaday(options));
                }
            } else {
                if (typeof args[0] === 'string' && typeof plugin[args[0]] === 'function') {
                    plugin[args[0]].apply(plugin, Array.prototype.slice.call(args,1));

                    if (args[0] === 'destroy') {
                        self.removeData('pikaday');
                    }
                }
            }
        });
    };

    $.fn.timePicker = function()
    {
        var args = arguments;

        if (!args || !args.length) {
            args = [{ }];
        }

        return this.each(function()
        {
            
            let default_override_options = {
                format: false,
                // minTime: '2:00 am',
                // maxTime: '1:00 pm',
                // meridiem: false,
                // arrowColor: false
            };

            var self   = $(this),
                plugin = self.data('TimePicker');
            if (plugin === undefined||!(plugin instanceof TimePicker)) {
                if (typeof args[0] === 'object') {
                    var options = $.extend(default_override_options, args[0]);
                    options.field = self[0];
                    self.data('TimePicker', new TimePicker(self[0],options));
                }
            } else {
                if (typeof args[0] === 'string' && typeof plugin[args[0]] === 'function') {
                    plugin[args[0]].apply(plugin, Array.prototype.slice.call(args,1));

                    if (args[0] === 'destroy') {
                        self.removeData('TimePicker');
                    }
                }
            }
        });
    };

}));


function aggancia_data(solo_future){
//	$('.data_picker').unbind();
    $(".data_picker").attr("autocomplete", "off");
    
    var start_date = null;
    
    if(typeof solo_future !== "undefined" && solo_future === true){
        start_date = new Date();
    }
    var options = {

    };
    $(".data_picker").pikaday(options);
//     $(".data_picker").bootstrapDP({
//         format: 'dd/mm/yyyy',
//         language: "it",
//         autoclose: true,
//         startDate: start_date,
//         todayHighlight: true,
//         disableTouchKeyboard: true,
// //		weekStart: 1
//     });
}
   

function aggancia_datatime(solo_future){
    
//	$('.data_picker').unbind();
    var pickers = $(".datatime_picker:not(.datatime_loaded)")
    pickers.attr("autocomplete", "off");
    
    var start_date = null;
    
    if(typeof solo_future !== "undefined" && solo_future === true){
        start_date = new Date();
    }

    pickers.each(function(){
        let self = $(this);
        
        let datetimepicker_wrapper = $("<div></div>");
        datetimepicker_wrapper.addClass("datetimepicker__wrapper");
        let input_data = $("<input placeholder='Data'>").addClass("form-control");
        let input_ora = $("<input placeholder='Ora'>").addClass("form-control");
        let wrapper_data = $("<div></div>").addClass("datatimepicker_data");
        for(let cl of self[0].classList){
            
            if(cl !="datatime_picker"&&cl!="auto_submit"){
                datetimepicker_wrapper.addClass(cl)
                
            }
        }
        
        wrapper_data.append(input_data);
        datetimepicker_wrapper.append(wrapper_data).append(input_ora);
        self.after(datetimepicker_wrapper);
        self.hide();
        let startVal = self.val();
        
        let startValArray = startVal.split(" ");
        console.log(startValArray);
        if(startValArray.length>0){
            input_data.attr("value",startValArray[0]);
            
            if(startValArray.length>1){
                input_ora.attr("value",startValArray[1]);
            }
        }
        input_data.pikaday();
        input_ora.timePicker();
        let updateSelf = function(){
            let val = input_data.val()+" "+input_ora.val();
            self.val(val).change();
        }
        input_data.change(updateSelf);
        input_ora.change(updateSelf);
        self.addClass("datatime_loaded")
    })

    
}

function aggancia_time(){
    $(".time_picker").attr("autocomplete", "off").timePicker();
}


function load_timehandlers(){
    aggancia_data()
    aggancia_datatime()
    aggancia_time()
}