<?php
namespace Txd\FieldTypes;
/**
 * Tipo txdAttributes per select
 */
class Select extends \Txd\txdAttributes {
    public function __construct($nome, $etichetta = "", $classi_html = []){
        parent::__construct($nome,"select",$etichetta, $classi_html);
    }

    /**
     * se il valore corrente è presente tra le opzioni ritorniamo l'etichetta corrispondente. altrimenti ritorniamo il valore vuoto
     *
     * @param [type] $valore
     * @return void
     */
    public function parse_valore($valore) {
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

        if(isset($this->opzioni_select[$valore])){
            if(is_array($this->opzioni_select[$valore])){
                $valore = $this->opzioni_select[$valore]['option_value'];
            }else{
                $valore = $this->opzioni_select[$valore];
            }
        }else{
            $valore = "";
        }

        return $valore;
    }

    public function init_tipo(){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
    }

    public function tipo_campo_form(){
        return "select";
    }

    public function build_view(){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
        return e($this->get_valore());
    }
    

    public function build_edit(){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
        return view("txd::FieldTypes.Select",["campo_obj"=>$this]);
    }

    // reimplementazione opzioni_select

    public $opzioni_select = [];
    /**
     * permette di impostare o recuperare le opzioni per i select a seconda del parametro ricevuto
     * @param NULL|array $info se NULL recupera le opzioni settate, se e' un array le imposta
     * @return $this|null 
     * @throws \Exception
     */
    public function opzioni_select($info = null){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

        if(is_null($info)){
            return $this->opzioni_select;
        }elseif(!is_array($info)){
            throw new \Exception(__FUNCTION__ ."() needs an array as parameter, ".gettype($info)." given");
        }else{
            $this->opzioni_select = $info;
        }

        return $this;
    }
}
